<?php

namespace Drupal\custom_elements\Processor;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Template\Attribute;
use Drupal\custom_elements\CustomElement;
use Drupal\custom_elements\CustomElementGeneratorTrait;

/**
 * Default processor for field item lists that passes processing on to items.
 */
class DefaultFieldItemListProcessor implements CustomElementProcessorWithKeyInterface {

  use CustomElementGeneratorTrait;

  /**
   * {@inheritdoc}
   */
  public function supports($data, $viewMode) {
    return $data instanceof FieldItemListInterface;
  }

  /**
   * {@inheritdoc}
   */
  public function addtoElement($data, CustomElement $element, $viewMode, $key = '') {
    assert($data instanceof FieldItemListInterface);
    $field_item_list = $data;

    // By default just handle each field item with cardinality 1 on its own.
    if ($field_item_list->getFieldDefinition()->getFieldStorageDefinition()->getCardinality() == 1) {
      foreach ($field_item_list as $field_item) {
        $nested_element = new CustomElement();
        $nested_element->setTagPrefix('field');
        $nested_element->setTag($field_item_list->getFieldDefinition()
          ->getType());
        $this->getCustomElementGenerator()
          ->process($field_item, $nested_element, $viewMode, $key);

        // When the element has only a single attribute, don't create a nested
        // tag.
        if (count($nested_element->getSlots()) == 0 && count($nested_element->getAttributes()) <= 1) {
          if ($attributes = $nested_element->getAttributes()) {
            $first_key = key($attributes);
            $element->setAttribute($key ?: $field_item_list->getName(), $attributes[$first_key]);
          }
        }
        // If the element has a single slot, just add that.
        elseif (count($nested_element->getSlots()) == 1 && count($nested_element->getAttributes()) == 0) {
          $slots = $nested_element->getSlots();
          $slot_entries = reset($slots);
          foreach ($slot_entries as $index => $slot) {
            $attributes = !empty($slot['attributes']) && $slot['attributes'] instanceof Attribute ? $slot['attributes']->toArray() : [];
            $tag = !empty($slot['tag']) ? $slot['tag'] : 'div';
            $element->setSlot($key ?: $field_item_list->getName(), $slot['content'], $tag, $attributes, $index);
          }
        }
        else {
          $element->setSlotFromCustomElement($key ?: $field_item_list->getName(), $nested_element);
        }
      }
    }
    // Render multiple fields individual, below another tag.
    else {
      $nested_elements = [];
      foreach ($field_item_list as $field_item) {
        $nested_element = new CustomElement();
        $nested_element->setTagPrefix('field');
        $nested_element->setTag($field_item_list->getFieldDefinition()->getType());
        $this->getCustomElementGenerator()->process($field_item, $nested_element, $viewMode);
        $nested_elements[] = $nested_element;
      }
      $element->setSlotFromNestedElements($key ?: $field_item_list->getName(), $nested_elements);
    }
  }

}
