D2: Declarative Diagramming
===========================

Introduction
------------

This module provides methods to generate SVGs using D2 diagram syntax.

The primary use case for this module is:

- Generating diagrams using D2 syntax

A submodule also provides a text filter that allows embedding D2 diagrams in
content.


Requirements
------------

D2 is a Go-based CLI. See installation instructions in the next section for how
to deploy it into your Drupal codebase.


Installation
------------

This module requires that the D2 binary be available in the Composer 'bin'
directory. As such, we provide a helper script to install the D2 binary via
Composer. Add the following to your `composer.json`:

```
    "repositories": [
        [...]
        {
            "type": "package",
            "package": {
                "name": "terrastruct/d2",
                "version": "0.7.1",
                "dist": {
                    "url": "https://github.com/terrastruct/d2/releases/download/v0.7.1/d2-v0.7.1-linux-amd64.tar.gz",
                    "type": "tar"
                }
            }
        }
    }
    [...]
    "autoload": {
        "classmap": [
            "web/modules/contrib/d2/src/ScriptHandler.php"
        ]
    },
    "scripts": {
        "post-install-cmd": [
            "Drupal\\d2\\ScriptHandler::installBinary"
        ],
        "post-update-cmd": [
            "Drupal\\d2\\ScriptHandler::installBinary"
        ]
    }
```

Otherwise, install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.


Similar projects
----------------

[MermaidJS](https://mermaid.js.org) is a mature Javascript library that generates diagrams and charts in-browser. Drupal support is provided by the [Mermaid Integration](https://www.drupal.org/project/mermaid) module.


Supporting this module
----------------------

Contact the [module maintainers](https://www.drupal.org/node/3565324/maintainers) if you'd like to support development, or request a specific feature.


Community documentation
-----------------------

For more information, check out the [D2 website](https://d2lang.com) and [documentation site](https://d2lang.com/tour/intro/).


Maintainers
-----------

Current maintainers for Drupal 11:

- Christopher Gervais (ergonlogic) - https://www.drupal.org/u/ergonlogic
- Scott Zhu Reeves (star-szr) - https://www.drupal.org/u/star-szr
