<?php

namespace Drupal\d2;

use Composer\Factory;
use DrupalFinder\DrupalFinderComposerRuntime;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Process\Process;

/**
 * Helper class to interface with the D2 CLI.
 */
class D2Helper {

  /**
   * Generate an SVG from D2 input.
   */
  public function generateSvg(string $d2_input): string {
    // Have `d2` use STDIN and STDOUT.
    $process = new Process([$this->d2Bin(), "-", "-"]);
    $process->setInput($d2_input);
    $process->run();

    if (!$process->isSuccessful()) {
        // @TODO: Log an error and return the input (?)
        throw new ProcessFailedException($process);
    }

    return $process->getOutput();
  }

  /**
   * Return the full path to the D2 CLI binary.
   */
  protected function d2Bin(): string {
    // @TODO: Allow use of a system-wide D2 binary.
    $composer_root = (new DrupalFinderComposerRuntime)->getComposerRoot();
    $config = Factory::createConfig(cwd: $composer_root);
    return ScriptHandler::getInstalledBinaryPath($config);
  }
}
