<?php

namespace Drupal\d2_filter\Plugin\Filter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\d2\D2Helper;
use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;

/**
 * @Filter(
 *   id = "filter_d2",
 *   title = @Translation("D2 Filter"),
 *   description = @Translation("Render D2 diagrams."),
 *   type = Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_IRREVERSIBLE,
 *   settings = {
 *     "theme" = "default",
 *     "filter_html_help" = 1,
 *     "filter_html_nofollow" = 0
 *   },
 *   weight = -10,
 * )
 */
class FilterD2 extends FilterBase {

  /**
   * {@inheritdoc}
   */
  public function process($text, $langcode) {
    // Replace content of the [d2] blocks.
    $text = preg_replace_callback('@\[d2\](.+?)\[/d2\]@s', function(array $matches) {
      return self::processD2($matches[1]);
    }, $text);

    return new FilterProcessResult($text);
  }

  /**
   * Callback to process a single [d2] block.
   */
  public function processD2($text) {
    return (new D2Helper())->getSvg($text);
  }

  /**
   * {@inheritdoc}
   */
  public function tips($long = FALSE) {
    return self::help($long);
  }

  /**
   * Provide help text.
   */
  static function help($long = FALSE) {
    if ($long) {
      return 'With <a href="https://d2lang.com" target="_blank" rel="noopener noreferrer">D2</a> you can create inline diagrams:<br/>'
          . '<code>[d2]<br/>direction: right<br/>&nbsp;&nbsp;Alice -> Bob<br/>[/d2]<br/></code>'
          . 'For more info, see <a href="http://drupal.org/project/d2">D2: Declarative Diagramming</a>.';
    }
    else {
      return 'Use <a href="https://d2lang.com" target="_blank" rel="noopener noreferrer">D2</a> to generate an inline diagram.';
    }
  }

}
