dev: install dev-enable fixtures-import
dev: ## Re-install the dev site with developer tools enabled, and fixtures imported.

FIXTURE_ENTITY_TYPES=node,user
FIXTURES_DIR=.local-dev/fixtures

dev-enable: ## Enable developer tools
	@$(ECHO) Enabling Developer tools.
	@$(DRUSH) pm:enable --yes d2_devel
	@@$(ECHO) "$(YELLOW)Enforcing (optional) configs.$(RESET)"
	@$(DRUSH) config-enforce:enforce

fixtures-import:
	@$(ECHO) Importing fixture content.
	@$(DRUSH) content-sync:import --yes --skiplist

fixtures-export:
	@$(ECHO) Exporting fixture content.
	@$(DRUSH) content-sync:export --yes --skiplist --entity-types=$(FIXTURE_ENTITY_TYPES)
	@$(ECHO) Deleting exported 'site-uuid'.
	@# Wait for slow filesystems to sync.
	@#until [ -f $(FIXTURES_DIR)/entities/site.uuid.yml ]; do sleep 1; done
	@rm -f $(FIXTURES_DIR)/entities/site.uuid.yml
	@$(ECHO) Deleting exported 'root' user.
	@rm -f `grep "value: root@example.com" $(FIXTURES_DIR) -rl`
	@$(ECHO) Deleting exported 'anonymous' user.
	@rm -f `grep "is_anonymous: true" $(FIXTURES_DIR) -rl`

