(function (Drupal, drupalSettings) {
  Drupal.behaviors.dadataAutocomplete = {
    attach(_context, _settings) {
      const fields = drupalSettings.dadataIntegration.fields || [];

      fields.forEach((cfg) => {
        const selector = cfg.field_selector || cfg.field_id;
        if (!selector) return;

        // Находим все элементы по querySelectorAll
        const inputs = document.querySelectorAll(selector);
        if (!inputs.length) return;

        inputs.forEach((input) => {
          if (input.dataset.dadataAttached) return;
          input.dataset.dadataAttached = "true";

          let apiUrl = `/dadata/suggest/${cfg.type}`;
          if (cfg.type === "address" && cfg.bound && cfg.bound !== "address") {
            apiUrl += `?bound=${encodeURIComponent(cfg.bound)}`;
          }

          let dropdown = null;
          let activeIndex = -1;

          const updateActiveItem = (index) => {
            if (!dropdown) return;
            const items = dropdown.querySelectorAll(".dadata-suggestion-item");
            items.forEach((el, i) => {
              el.classList.toggle("active", i === index);
            });
          };

          input.addEventListener("input", (e) => {
            const query = e.target.value.trim();
            if (dropdown) dropdown.innerHTML = "";

            if (query.length < 3) {
              if (dropdown) {
                dropdown.remove();
                dropdown = null;
              }
              return;
            }

            const url =
              apiUrl +
              (apiUrl.includes("?") ? "&" : "?") +
              "q=" +
              encodeURIComponent(query);

            fetch(url)
              .then((res) => res.json())
              .then((data) => {
                if (!data?.suggestions?.length) {
                  if (dropdown) {
                    dropdown.remove();
                    dropdown = null;
                  }
                  return;
                }

                if (!dropdown) {
                  dropdown = document.createElement("ul");
                  dropdown.classList.add("dadata-suggestions");
                  input.parentNode.appendChild(dropdown);
                } else {
                  dropdown.innerHTML = "";
                }

                activeIndex = -1;

                data.suggestions.forEach((s, i) => {
                  const li = document.createElement("li");
                  li.textContent = s.value;
                  li.classList.add("dadata-suggestion-item");

                  li.addEventListener("click", () => {
                    input.value = s.value;
                    dropdown.remove();
                    dropdown = null;
                  });

                  dropdown.appendChild(li);
                });
              })
              .catch((err) => console.error("DaData error", err));
          });

          input.addEventListener("keydown", (e) => {
            if (!dropdown) return;
            const items = dropdown.querySelectorAll(".dadata-suggestion-item");
            if (!items.length) return;

            if (e.key === "ArrowDown") {
              e.preventDefault();
              activeIndex = (activeIndex + 1) % items.length;
              updateActiveItem(activeIndex);
            } else if (e.key === "ArrowUp") {
              e.preventDefault();
              activeIndex = (activeIndex - 1 + items.length) % items.length;
              updateActiveItem(activeIndex);
            } else if (e.key === "Enter") {
              if (activeIndex >= 0 && items[activeIndex]) {
                e.preventDefault();
                input.value = items[activeIndex].textContent;
                dropdown.remove();
                dropdown = null;
              }
            }
          });

          document.addEventListener("click", (e) => {
            if (dropdown && !dropdown.contains(e.target) && e.target !== input) {
              dropdown.remove();
              dropdown = null;
            }
          });

          input.addEventListener("blur", () => {
            setTimeout(() => {
              if (dropdown) {
                dropdown.remove();
                dropdown = null;
              }
            }, 200);
          });
        });
      });
    },
  };
})(Drupal, drupalSettings);