# Dark Mode Toggle module

When your theme supports dark mode, this module provides a block that allows
visitors to toggle between the light and dark variants.

The Dark Mode Toggle block features three buttons:
- Light: switches to the light mode.
- Dark: switches to the dark mode.
- System: follows the user's browser preference.

The user's choice is saved in the browser's local storage, so their preference
is remembered when navigating pages, or they return to the site.

When dark mode is preferred, this module sets the `data-dmt-mode` attribute to
`dark` on the `<html>` element (or `light` for light mode). Additionally, a
`data-dmt-source` attribute is added to indicate the source of the dark mode
choice, which can either be `user` or `system`. It is up to the theme to style
the site correctly based on the selected variant.

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

To set up the Dark Mode Toggle block, navigate to Administration » Structure »
Block layout and place it in one of the available regions. The basic Twig
template `dark-mode-toggle.html.twig` provides the block's content, which can be
overridden in a custom theme.

## Tailwind CSS integration

To use this with your theme, configure your CSS framework to respond to the
`data-dmt-mode` attribute. For example, with Tailwind CSS:

```
@custom-variant dark (&:where([data-dmt-mode=dark], [data-dmt-mode=dark] *));
```

## Contributing

Contributions are welcome! You may set up your local development environment
using any stack you prefer. DDEV is optional and supported.

If you choose to use DDEV:

1. Clone the repository.
1. Install DDEV. See [DDEV installation guide](https://docs.ddev.com/en/stable/users/install/).
1. Run the following commands:
   ```
   ddev start
   ddev poser
   ddev symlink-project
   ```
   For more information about the `poser` and `symlink-project` commands, visit
   [ddev-drupal-contrib commands](https://github.com/ddev/ddev-drupal-contrib#commands).

After your environment is ready, you need to install the Drupal site and enable
the module. Drush is available in all setups and can be used as follows:

- Install the site:
  ```
  drush site:install
  ```
- Enable the module:
  ```
  drush pm:install dark_mode_toggle
  ```
