/**
 * @file
 * Use previously stored value or OS preference to set initial dark mode.
 *
 * This should be loaded in the header to avoid FOUC, and uses the previously
 * stored value of the local storage. When not set, the OS preference is used to
 * set the initial "dark mode".
 */

(() => {
  const mode = localStorage.getItem('dmt-mode');
  const isModeDark =
    mode === 'dark' ||
    (!mode && window.matchMedia('(prefers-color-scheme: dark)').matches);

  // Use the 'data-dmt-mode' attribute to set the initial dark mode.
  document.documentElement.setAttribute(
    'data-dmt-mode',
    isModeDark ? 'dark' : 'light',
  );

  // The 'data-dmt-source' attribute is used to indicate the source of the
  // "dark mode". It can be 'user' when the user explicitly chooses the mode, or
  // 'system' when the system preference is used.
  document.documentElement.setAttribute(
    'data-dmt-source',
    mode ? 'user' : 'system',
  );
})();
