<?php

declare(strict_types=1);

namespace Drupal\dark_mode_toggle\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * Defines hooks for the Dark Mode Toggle module.
 */
class DarkModeToggleHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): ?string {
    if ($route_name === 'help.page.dark_mode_toggle') {
      $output = '<h2>' . $this->t('About') . '</h2>';
      $output .= '<p>' . $this->t('The Dark Mode Toggle module provides a block that allows visitors to toggle between the light and variant of a site. For more information, see the <a href=":project_link">online documentation for the Dark Mode Toggle module</a>.', [
        ':project_link' => 'https://www.drupal.org/project/dark_mode_toggle',
      ]) . '</p>';
      $output .= '<h2>' . $this->t('Uses') . '</h2>';
      $output .= '<p>' . $this->t('To use this module, add the Dark Mode Toggle block to your site. You can place the block on the <a href=":block_config_link">Block layout page</a>. Update your theme to render and style the page using a dark color scheme when the <code>data-dmt-mode</code> attribute on the <code>&lt;html&gt;</code> element is set to <code>dark</code>.', [
        ':block_config_link' => Url::fromRoute('block.admin_display')->toString(),
      ]) . '</p>';

      return $output;
    }

    return NULL;
  }

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme(): array {
    return [
      'dark_mode_toggle' => [
        'variables' => [
          'attributes' => [],
        ],
      ],
    ];
  }

}
