((drupalSettings) => {
  const settings = drupalSettings.dark_mode_user;
  if (settings === 'system') {
    const isModeDark = window.matchMedia(
      '(prefers-color-scheme: dark)',
    ).matches;
    document.documentElement.setAttribute(
      'data-dmu-mode',
      isModeDark ? 'dark' : 'light',
    );
    document.documentElement.setAttribute('data-dmu-source', 'system');
  }
  else {
    document.documentElement.setAttribute('data-dmu-mode', settings);
    document.documentElement.setAttribute('data-dmu-source', 'user');
  }
})(drupalSettings);
