# Dark Mode User

The **Dark Mode User** module provides a standalone, user-configurable dark mode system for Drupal.
It replaces — rather than extends — the original [Dark Mode Toggle](https://www.drupal.org/project/dark_mode_toggle) module.

This module was inspired by the work of the original Dark Mode Toggle maintainer — many thanks for their contribution to the Drupal community!

Related issue on Drupal.org: [Add per-user dark mode setting](https://www.drupal.org/project/dark_mode_toggle/issues/3554120)

---

## Overview

The **Dark Mode User** module allows both **system-wide** and **per-user** control over the site's color mode.
It supports three modes:

- **Light** — always use the light theme
- **Dark** — always use the dark theme
- **System** — follow the user’s operating system or browser preference

---

## Configuration

### Global configuration
Administrators can define the default behavior at: /admin/config/user-interface/dark-mode-user

---

This configuration determines which mode is used by default for all visitors, including **anonymous users**.

### Per-user override
Users with the appropriate permission can override the global setting on their **user profile page**.
This allows each authenticated user to select their preferred color mode (`light`, `dark`, or `system`), independent of the site-wide configuration.

---

## Features

- Fully self-contained — does **not** require the [Dark Mode Toggle](https://www.drupal.org/project/dark_mode_toggle) module.
- Provides **global** and **per-user** dark mode settings.
- Supports three configurable display modes: `light`, `dark`, `system`.
- Anonymous users follow the global site configuration.
- Clean integration with the user profile form.

---

## Installation

1. Install the module (`dark_mode_user`) as you would any other Drupal module.
2. Configure global defaults at `/admin/config/user-interface/dark-mode-user`.
3. Grant the **“Manage own dark mode preference”** permission to roles that should be able to override the global setting.

---

## Usage

When dark mode is preferred, this module sets the `data-dmu-mode` attribute to dark on the <html> element (or light for light mode).
Additionally, a `data-dmu-source` attribute is added to indicate the source of the dark mode choice, which can either be user or system.
It is up to the theme to style the site correctly based on the selected variant.

---

## Tailwind CSS integration

To use this with your theme, configure your CSS framework to respond to the
`data-dmu-mode` attribute. For example, with Tailwind CSS:

```
@custom-variant dark (&:where([data-dmu-mode=dark], [data-dmu-mode=dark] *));
```

---

## Contributing

Contributions are welcome! You may set up your local development environment
using any stack you prefer. DDEV is optional and supported.

If you choose to use DDEV:

1. Clone the repository.
1. Install DDEV. See [DDEV installation guide](https://docs.ddev.com/en/stable/users/install/).
1. Run the following commands:
   ```
   ddev start
   ddev poser
   ddev symlink-project
   ```
   For more information about the `poser` and `symlink-project` commands, visit
   [ddev-drupal-contrib commands](https://github.com/ddev/ddev-drupal-contrib#commands).

After your environment is ready, you need to install the Drupal site and enable
the module. Drush is available in all setups and can be used as follows:

- Install the site:
  ```
  drush site:install
  ```
- Enable the module:
  ```
  drush pm:install dark_mode_user
  ```

---

## Maintainers

- Maintained by [Kurucz István](https://www.drupal.org/u/nevergone) his volunteer time.
- Inspired by the [Dark Mode Toggle](https://www.drupal.org/project/dark_mode_toggle) project and its maintainer.
