<?php

declare(strict_types=1);

namespace Drupal\dark_mode_user\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Dark Mode User settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'dark_mode_user_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['dark_mode_user.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['system_default'] = [
      '#type' => 'radios',
      '#required' => TRUE,
      '#title' => $this->t('System default settings'),
      '#description' => $this->t('If the user does not set a personal preference, this global setting will apply. It is also used for anonymous users. When set to “system”, the theme will follow the operating system or browser color scheme preference (light or dark).'),
      '#default_value' => $this->config('dark_mode_user.settings')->get('system_default'),
      '#options' => [
        'light' => $this->t('Light'),
        'dark' => $this->t('Dark'),
        'system' => $this->t('System'),
      ]
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('dark_mode_user.settings')
      ->set('system_default', $form_state->getValue('system_default'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
