<?php

namespace Drupal\data_policy;

use Drupal\Core\Extension\ModuleInstaller;

/**
 * Class to handle the module installation and uninstallation.
 *
 * @package Drupal\data_policy
 */
class DataPolicyModuleInstaller extends ModuleInstaller {

  /**
   * {@inheritdoc}
   */
  public function uninstall(array $module_list, $uninstall_dependents = TRUE) {
    $storage = \Drupal::entityTypeManager()
      ->getStorage('data_policy');
    $entityId = \Drupal::configFactory()
      ->getEditable('data_policy.data_policy')
      ->get('entity_id');

    if (in_array('data_policy', $module_list) && $entityId) {
      $storage->load($entityId)->delete();
    }

    return parent::uninstall($module_list, $uninstall_dependents);
  }

}
