<?php

namespace Drupal\datafield\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Plugin type manager for data field formatters.
 *
 * @ingroup field_formatter
 */
class DataFieldFormatterPluginManager extends DefaultPluginManager {

  /**
   * An array of formatter options for each field type.
   *
   * @var array
   */
  protected $formatterOptions;

  /**
   * The field type manager to define field.
   *
   * @var \Drupal\Core\Field\FieldTypePluginManagerInterface
   */
  protected $fieldTypeManager;

  /**
   * Constructs a Data Field Formatter Plugin Manager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/DataField/FieldFormatter',
      $namespaces,
      $module_handler,
      'Drupal\datafield\Plugin\DataFieldFormatterInterface',
      FieldFormatter::class,
      'Drupal\Core\Field\Annotation\FieldFormatter',
    );
    $this->alterInfo($this->getType());
    $this->setCacheBackend($cache_backend, 'data_field_formatter_info');
  }

  /**
   * {@inheritdoc}
   */
  protected function getType() {
    return 'data_field_formatter_types_plugins';
  }

  /**
   * {@inheritdoc}
   */
  public function getPluginClass($type) {
    return $this->getDefinition($type)['class'];
  }

}
