# Date HTML Segmentation Formatter

The **Date HTML Segmentation Formatter** provides an additional field formatter for date fields.  
Works with smart date.

It outputs start and end dates as individually wrapped HTML elements, making it easy
to target them via CSS or JavaScript for custom layouts.

## Features

- Adds a new field formatter: **Date HTML Segmentation Formatter**.
- Splits Smart Date output into distinct HTML segments (`start`, `separator`, `end`).
- Enables precise theming with CSS or custom Twig templates.
- Works seamlessly with Views and multilingual sites.

## Installation

- Install the module using Composer:
   ```bash
   composer require drupal/date_html_segmentation_formatter

## Configuration

1. Go to "Manage Display" of a node with date field, chose `Segmentation Formatter` as Format.
2. Adjust option or take default
3. Save the content Type
 ->  Open a changed node, and you can use the segmented date by its css selectors.

## Example use case

Whenever you want to have more colours in a date display. Or other CSS.


## Requirements

- Drupal Core 10 or 11
- No external dependencies

Optional: [Smart Date](https://www.drupal.org/project/smart_date)
