<?php

declare(strict_types=1);

namespace Drupal\drpw_field;

use Drupal\views\Plugin\views\query\Sql as ViewsQuerySql;

/**
 * Interface for daterangepicker_views_operator plugins.
 */
interface DateRangePickerViewsOperatorInterface {

  /**
   * Returns the translated plugin label.
   *
   * // phpcs:ignore
   * @return string
   */
  public function label(): string;

  /**
   * Returns the translated plugin description.
   *
   * // phpcs:ignore
   * @return string
   */
  public function description(): string;

  /**
   * Returns the translated operator short name.
   *
   * // phpcs:ignore
   * @return string
   */
  public function shortName(): string;

  /**
   * Returns operator values.
   *
   * // phpcs:ignore
   * @return int
   */
  public function values(): int;

  /**
   * The execution method or logic for the operator.
   *
   * @param \Drupal\views\Plugin\views\query\Sql $query
   *   The views query object.
   * @param int $group
   *   The views group position.
   * @param int $position
   *   The argument or placeholder position.
   * @param array $options
   *   The views filter plugin options.
   * @param string $field
   *   The fully qualified field name.
   * @param mixed $value
   *   The exposed value selected by user.
   */
  public function method(ViewsQuerySql $query, int $group, int $position, array $options, string $field, mixed $value): void;

}
