<?php

declare(strict_types=1);

namespace Drupal\drpw_field;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for daterangepicker_views_operator plugins.
 */
abstract class DateRangePickerViewsOperatorPluginBase extends PluginBase implements DateRangePickerViewsOperatorInterface {

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function description(): string {
    return (string) $this->pluginDefinition['description'];
  }

  /**
   * {@inheritdoc}
   */
  public function shortName(): string {
    return (string) $this->pluginDefinition['short_name'];
  }

  /**
   * {@inheritdoc}
   */
  public function values(): int {
    return $this->pluginDefinition['values'];
  }

}
