<?php

declare(strict_types=1);

namespace Drupal\drpw_field;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\drpw_field\Attribute\DateRangePickerViewsOperator as DateRangePickerViewsOperatorAttribute;

/**
 * DateRangePickerViewsOperator plugin manager.
 */
final class DateRangePickerViewsOperatorPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/DateRangePicker/ViewsOperator',
      $namespaces,
      $module_handler,
      DateRangePickerViewsOperatorInterface::class,
      DateRangePickerViewsOperatorAttribute::class
    );

    $this->alterInfo('daterangepicker_views_operator_info');
    $this->setCacheBackend($cache_backend, 'daterangepicker_views_operator_plugins');
  }

}
