/**
 * @file
 */

(($, Drupal) => {
  Drupal.behaviors.dateTimeReset = {
    attach(context) {
      once('datetime_reset', '.datetime-reset-button', context).forEach(
        (button) => {
          button.addEventListener(
            'click',
            (event) => {
              event.preventDefault();
              event.stopPropagation();
              const idPrefix = button.name.substr(6);
              const dateId = `${idPrefix}-date`;
              const timeId = `${idPrefix}-time`;
              const date = document.getElementById(dateId);
              if (date) {
                date.value = '';
              }
              const time = document.getElementById(timeId);
              if (time) {
                time.value = '';
              }
            },
            true,
          );
        },
      );
    },
  };
})(jQuery, Drupal);
