# Db Cleanup

Provides drush commands in order to monitor the space used by your database and try to reduce it if
the "data_free" of some tables have grown too much.

## Installation

### Composer
If your site is [managed via Composer](https://www.drupal.org/node/2718229), use
Composer to download the module.
   ```sh
   composer require "drupal/db_cleanup"
   ```
## Usage

### Available drush commands

   ```sh
   drush db:check-fragmentation
   ```
Display tables that can be rebuilt in order to save some space. Fragmentation ratio is calculated based on the
space of the current data of the table compared to the "data_free" that can potentially be reclaimed.

   ```sh
   drush db:cleanup-tables --threshold=20
   drush db:cleanup-tables --dry-run
   ```
**Make sure to back up your database before running this command.**  
Cleanup tables based on a threshold of fragmentation ratio (default to 10 so only tables with more than 10% fragmentation ratio would be rebuilt).
Use the dry-run option to see which tables would be rebuilt without actually running the cleanup. 

   ```sh
   drush db:check-db-size --number=20
   ```
Display the biggest tables in your database and the total size of the database.
Number option to choose the number of tables to display (default to 30).

   ```sh
   drush db:check-node-revisions --limit=20
   ```
Display the nodes with the most revisions and the average number of revisions per node.
Limit option to choose the number of nodes to display (default to 10).