<?php

namespace Drupal\db_health\Commands;

use Drush\Commands\DrushCommands;

/**
 * Provides a Drush command to run db_health_cron.
 */
class DbHealthCronCommands extends DrushCommands {

  /**
   * Runs the db_health_cron hook.
   *
   * @command db-health:run
   * @aliases dh:run
   */
  public function run() {
    $force = TRUE;

    $this->output()->writeln('▶️ Running db_health_cron...');

    // Execute the hook_cron for the module.
    \Drupal::moduleHandler()->invoke('db_health', 'cron', [$force]);

    $this->output()->writeln('✅ db_health_cron completed.');
  }

}
