# DB Health Drupal Module

## Overview

**DB Health** is a Drupal module designed to monitor, analyze, and visualize the health and size of your Drupal database. It provides site administrators with insights into database growth, logs, and configuration, helping to maintain optimal performance and prevent issues related to database bloat.

---

## Features

- **Database Size Monitoring:** Track the size of your database and its tables over time.
- **Visual Charts:** Interactive charts display database size trends using custom CSS/JS and Twig templates.
- **Health Logs:** View and manage logs related to database health checks.
- **Configurable Settings:** Adjust thresholds, logging options, and notification preferences via an admin form.
- **Drush Integration:** Run health checks and cron tasks from the command line.
- **Admin Dashboard:** Centralized dashboard for viewing database health status and charts.
- **Extensible Architecture:** Easily add new checks or integrate with other monitoring tools.

---

## Folder Structure

```
db_health/
├── css/                      # Styles for charts
├── js/                       # JS for chart rendering
├── src/
│   ├── DbHealthSizeChecker.php   # Core logic for checking DB size
│   ├── Commands/
│   │   └── DbHealthCronCommands.php  # Drush commands for cron/health checks
│   ├── Controller/
│   │   └── DbHealthController.php    # Controller for dashboard and charts
│   └── Form/
│       ├── DbHealthLogsForm.php      # Form for viewing/managing logs
│       └── DbHealthSettingsForm.php  # Form for configuring settings
├── templates/
│   └── db-health-table-chart.html.twig   # Twig template for chart display
├── *.yml, *.install, *.module, *.txt
```

---

## Main Functionalities

### 1. Database Size Monitoring

- **DbHealthSizeChecker.php:** Core class that calculates the size of the database and its tables. Can be triggered manually or via cron.
- **Dashboard:** The main admin page displays current and historical database size, with breakdowns by table.

### 2. Visual Charts

- **db-health-table-chart.html.twig:** Custom Twig template renders interactive charts.
- **chart.css & chart.js:** Provide styling and dynamic charting for database size visualization.

### 3. Health Logs

- **DbHealthLogsForm.php:** Admin form to view, filter, and manage logs generated by health checks.
- **Logging:** Logs are created during each health check, recording size, warnings, and actions taken.

### 4. Configurable Settings

- **DbHealthSettingsForm.php:** Admin form to configure thresholds (e.g., warning size), enable/disable logging, and set notification preferences.
- **Config Storage:** Settings are stored in Drupal config and used by all health check routines.

### 5. Drush Integration

- **DbHealthCronCommands.php:** Provides Drush commands to run health checks and cron tasks from the command line.
- **Automation:** Integrate with server cron or CI/CD for automated monitoring.

### 6. Admin Dashboard

- **DbHealthController.php:** Controller for the main dashboard page, which aggregates data, renders charts, and displays status messages.

---

## Key Classes & Files

- **DbHealthSizeChecker.php:** Main logic for calculating and reporting database size.
- **DbHealthController.php:** Handles dashboard display and chart rendering.
- **DbHealthLogsForm.php:** UI for viewing and managing health logs.
- **DbHealthSettingsForm.php:** UI for configuring module settings.
- **DbHealthCronCommands.php:** Drush command integration.
- **db-health-table-chart.html.twig:** Chart visualization template.

---

## Usage

### Viewing Database Health

1. Navigate to the DB Health dashboard in the Drupal admin menu.
2. Review current database size, table breakdowns, and historical trends.
3. View visual charts for quick insights.

### Configuring Settings

1. Go to the DB Health settings form.
2. Set thresholds for warnings (e.g., max DB size), enable/disable logging, and configure notifications.
3. Save your changes.

### Managing Logs

1. Access the DB Health logs form.
2. Filter, review, and clear logs as needed.

### Running Health Checks via Drush

```bash
drush db-health:check
drush db-health:cron
```

### Chart Visualization

- Charts are automatically rendered on the dashboard using the included JS/CSS and Twig template.

---

## Requirements

- Drupal 9 or 10
- PHP 7.4+
- Appropriate permissions for viewing and configuring DB Health

---

## Extending

- Add new health checks by extending `DbHealthSizeChecker.php`.
- Integrate with external monitoring tools via Drush or custom services.
- Customize chart appearance by editing `chart.css` and `chart.js`.

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
