<?php

namespace Drupal\db_health\Commands;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Drush command to run db_health_cron.
 */
class DbHealthCronCommands extends DrushCommands {

  /**
   * The module handler service.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * Constructs a new DbHealthCronCommands object.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler service.
   */
  public function __construct(ModuleHandlerInterface $module_handler) {
    parent::__construct();
    $this->moduleHandler = $module_handler;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('module_handler')
    );
  }

  /**
   * Runs the db_health_cron hook.
   *
   * @command db-health:run
   * @aliases dh:run
   */
  public function run() {
    $force = TRUE;

    $this->output()->writeln('▶️ Running db_health_cron...');

    // Execute the hook_cron for the module using dependency injection.
    $this->moduleHandler->invoke('db_health', 'cron', [$force]);

    $this->output()->writeln('✅ db_health_cron completed.');
  }

}
