<?php

namespace Drupal\dbee\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Drupal\user\Plugin\Validation\Constraint\UserMailUnique;

/**
 * Checks if a user's email address is unique on the site.
 */
#[Constraint(
    id: 'UserMailUniqueDbee',
    label: new TranslatableMarkup('User email encrypted unique', [], ['context' => 'Validation'])
)]
class UserMailUniqueDbee extends UserMailUnique {

  /**
   * {@inheritdoc}
   */
  public function validatedBy(): string {
    return '\Drupal\dbee\Plugin\Validation\Constraint\UserMailUniqueDbeeValidator';
  }

}
