<?php

namespace Drupal\Tests\dbee\Functional;

use Drupal\user\Entity\User;

/**
 * Test compatibility with the mail_login contrib module.
 *
 * Use loadByProperties(['mail]) in mail_login_validate_authentication() for
 * login, concerning branch 8.x-2.x, 3.2 and 4.2.
 *
 * @group dbee
 */
class DbeeMailLoginTest extends DbeeWebTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['mail_login', 'dbee'];

  /**
   * User to login.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $loginUser;

  /**
   * User to login mail.
   *
   * @var string
   */
  protected $mail;


  /**
   * User to login password.
   *
   * @var string
   */
  protected $password;

  /**
   * User to login name.
   *
   * @var string
   */
  protected $name;

  /**
   * Check Login by Email.
   */
  public function testLoginByEmail() {
    $provider = '@eXample.com';
    $edit = [];
    $this->password = \Drupal::service('password_generator')->generate();
    $this->mail = $this->randomMachineName() . $provider;
    $this->name = $this->randomMachineName();
    $edit['name'] = $this->name;
    $edit['mail'] = $this->mail;
    $edit['pass'] = $this->password;
    $edit['status'] = 1;
    $edit['init'] = $edit['mail'];
    $this->loginUser = User::create($edit);
    $this->loginUser->save();

    // Alter the email case.
    $edit1 = [
      'name' => mb_strtoupper($this->mail),
      'pass' => $this->password,
    ];
    $this->drupalGet('user/login');
    $this->submitForm($edit1, 'Log in');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains($this->name);
  }

}
