<?php

namespace Drupal\dbee;

use Drupal\user\UserStorageSchema;
use Drupal\Core\Field\FieldStorageDefinitionInterface;

/**
 * Make changes on the table schema storing emails.
 *
 * This actions are for consistency, avoiding mismatches between the declared
 * schema and the real database structure. The new table schema needs to be
 * applied during installing the dbee module, using _dbee_length_email_fields().
 */
class DbeeUserStorageSchema extends UserStorageSchema {

  /**
   * {@inheritdoc}
   */
  protected function getSharedTableFieldSchema(FieldStorageDefinitionInterface $storage_definition, $table_name, array $column_mapping) {
    $schema = parent::getSharedTableFieldSchema($storage_definition, $table_name, $column_mapping);
    $field_name = $storage_definition->getName();

    if ($table_name == 'users_field_data') {
      switch ($field_name) {
        case 'mail':
        case 'init':
          // Extend the length in order to store the encrypted mail.
          if (isset($schema['fields'][$field_name])) {
            $column = $schema['fields'][$field_name];
            if (is_array($column) && $column['type'] == 'varchar') {
              $schema['fields'][$field_name]['type'] = 'text';
              unset($schema['fields'][$field_name]['length']);
            }
          }
          if ($field_name == 'mail') {
            // Since mails are encrypted, the index on mails is useless.
            $name = $storage_definition->getName();
            $real_key = $this->getFieldSchemaIdentifierName($storage_definition->getTargetEntityTypeId(), $name);
            if (isset($schema['indexes'][$real_key])) {
              unset($schema['indexes'][$real_key]);
            }
          }
      }
    }
    return $schema;
  }

}
