<?php

namespace Drupal\dbee\Entity;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\user\Entity\User;
use Drupal\user\UserInterface;

/**
 * Extends the core User class to ensure email addresses are decrypted.
 */
class DbeeUser extends User implements UserInterface {

  /**
   * {@inheritdoc}
   */
  public function getEmail() {
    return dbee_decrypt($this->get('mail')->value);
  }

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = parent::baseFieldDefinitions($entity_type);
    if (isset($fields['mail'])) {
      // Replace ->addConstraint('UserMailUnique') by the dbee constraint.
      $fields['mail']->setConstraints([]);
      $fields['mail']->addConstraint('UserMailUniqueDbee')
        ->addConstraint('UserMailRequired')
        ->addConstraint('ProtectedUserField');
      $fields['mail']->setDescription(t('The encrypted email of this user.'));
    }
    return $fields;
  }

}
