<?php

declare(strict_types=1);

namespace Drupal\Tests\dbee\Functional;

use Drupal\key\Entity\Key;
use Drupal\user\Entity\User;

/**
 * Tests the user interface for importing/exporting a single configuration.
 *
 * @group config
 */
class DbeeChangeEncryption extends DbeeWebTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['dbee', 'user', 'encrypt', 'real_aes', 'key'];

  /**
   * {@inheritdoc}
   */
  protected function writeSettings(array $settings) {
    // No private path: store key in database, in order to easily access to the
    // key value.
  }

  /**
   * {@inheritdoc}
   */
  public function testChangeEncryptionKey() {
    $user_name = 'john';
    $user_mail = "{$user_name}@provider.com";
    $account = $this->drupalCreateUser(['administer keys', 'administer dbee'], $user_name, FALSE, ['mail' => $user_mail]);
    $this->drupalLogin($account);

    $mail = $account->getEmail();
    $this->assertEquals($mail, $user_mail, 'The load mail is the same than the registered one.');
    $bytes = 32;
    $new_key = random_bytes($bytes);
    $key = Key::load(dbee_current_key_id());
    $key_label = $key->label();
    $url = 'admin/config/system/keys/manage/' . $key->id();
    $input = [
      'label' => $key_label,
      'description' => $key->getDescription(),
      'key_type' => 'encryption',
      'key_type_settings[key_size]' => ($bytes * 8),
      'key_input_settings[key_value]' => $new_key,
      'key_input_settings[base64_encoded]' => FALSE,
    ];
    // Attempt an import with a missing ID.
    $this->drupalGet($url);
    $this->submitForm([], 'Edit');
    $this->submitForm($input, 'Save');
    $this->assertSession()->pageTextContains("The key {$key_label} has been updated.");

    $account_reload = User::load($account->id());
    $mail_reload = $account_reload->getEmail();

    $this->assertEquals($mail_reload, $user_mail, 'The load mail is the same than the registered one.');
  }

}
