<?php

namespace Drupal\Tests\dbee\Functional;

use Drupal\user\Entity\User;

/**
 * Test altering database schema.
 *
 * Mail and init columns are 254 length by core. The dbee module increase this
 * limit in order to save the encrypted email.
 *
 * @group dbee
 */
class DbeeTableSchema extends DbeeWebTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['dbee'];

  /**
   * User with maximum_length email.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $userLongEmail;

  /**
   * Long mail.
   *
   * @var string
   */
  protected $mail;

  /**
   * Check extending the mail column length.
   *
   * From the _dbee_length_email_fields() in dbee.install.
   */
  public function testSavingLongEmail() {
    $provider = '@eXample.com';
    $length_max = 254;
    $length_random = $length_max - strlen($provider);
    $mail = $this->randomMachineName($length_random) . $provider;
    if (strlen($mail) != $length_max) {
      $this->assertSession()->assert(FALSE, 'The tested email is not maximum length.');
    }
    else {
      $this->mail = $mail;

      $encrypted = dbee_encrypt($this->mail);
      $encrypted_length = strlen($encrypted);
      $this->assertSession()->assert(($encrypted_length >= $length_max), 'The encrypted long mail exceed the maximum mail length.');

      $edit = [];
      $edit['name'] = $this->randomMachineName();
      $edit['mail'] = $this->mail;
      $edit['status'] = 1;
      // Test both mail and init columns.
      $edit['init'] = $edit['mail'];
      $this->userLongEmail = User::create($edit);
      // Try to save it in the database.
      $this->userLongEmail->save();
      // If fails, fatal error occurs: SQLSTATE[22001]: String data, right
      // truncated: 1406 Data too long for column 'mail' at row 1: INSERT INTO
      // "users_field_data" ...
    }
  }

}
