<?php

namespace Drupal\Tests\dbee\Kernel;

use Drupal\Core\Config\ConfigImporter;
use Drupal\Core\Config\StorageComparer;

/**
 * Enabled/disabled the dbee module via config.
 *
 * @group dbee
 */
class DbeeFromConfig extends DbeeKernelTestBase {

  /**
   * Modules to remove.
   *
   * @var array
   */
  protected $modulesToRemove = [];

  /**
   * Config Importer object used for testing.
   *
   * @var \Drupal\Core\Config\ConfigImporter
   */
  protected $configImporter;

  /**
   * Remove dbee module only via config import.
   */
  public function testConfigUninstallDbee() {
    $this->modulesToRemove = ['dbee'];
    self::testRemoveModules();
  }

  /**
   * Remove dbee module with dependencies via config import.
   *
   * As a consequence dbee key and encryption profile will be deleted.
   */
  public function testConfigUninstallDbeeWithDependencies() {
    // This test will delete the dbee encrypt profile and key config.
    $this->modulesToRemove = ['dbee', 'key', 'encrypt', 'real_aes'];
    self::testRemoveModules();
  }

  /**
   * Tests that the config module can be uninstalled via CLI config import.
   */
  protected function testRemoveModules() {
    if (empty($this->modulesToRemove)) {
      $this->assertTrue(FALSE, 'No modules to removes from the test configuration.');
    }
    else {
      foreach ($this->modulesToRemove as $module) {
        $this->assertTrue($this->container->get('module_handler')->moduleExists($module), 'Module ' . $module . ' should be installed.');
      }
      // Set up the ConfigImporter object for testing.
      // Export active config to sync.
      $this->copyConfig($this->container->get('config.storage'), $this->container->get('config.storage.sync'));
      $storage_comparer = new StorageComparer(
        $this->container->get('config.storage.sync'),
        $this->container->get('config.storage')
      );
      $this->configImporter = new ConfigImporter(
        $storage_comparer->createChangelist(),
        $this->container->get('event_dispatcher'),
        $this->container->get('config.manager'),
        $this->container->get('lock'),
        $this->container->get('config.typed'),
        $this->container->get('module_handler'),
        $this->container->get('module_installer'),
        $this->container->get('theme_handler'),
        $this->container->get('string_translation'),
        $this->container->get('extension.list.module'),
        $this->container->get('extension.list.theme')
      );
      $sync = $this->container->get('config.storage.sync');
      $extensions = $sync->read('core.extension');
      foreach ($this->modulesToRemove as $module) {
        unset($extensions['module'][$module]);
      }
      $sync->write('core.extension', $extensions);
      $this->configImporter->reset()->import();
      foreach ($this->modulesToRemove as $module) {
        $this->assertFalse($this->container->get('module_handler')->moduleExists($module), 'Module ' . $module . ' should be uninstalled.');
      }

      // Check the users mails status.
      // Test all email address.
      if (!empty($this->usersInfo)) {
        $enabling = FALSE;
        $test_message = ($enabling) ? 'All users are encrypted and can be decrypted back' : 'All users are uncrypted and valid';
        $this->assertTrue($this->dbeeAllUsersValid($this->usersInfo, $enabling), $test_message);
      }
    }
  }

}
