<?php

namespace Drupal\dboptimize\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Database\Database;

/**
 * Configure database optimization settings.
 */
class DbOptimizeSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'dboptimize_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['dboptimize.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('dboptimize.settings');

    $form['cron_message'] = [
      '#markup' => '<p>' . $this->t('Ensure your crontab is configured to run cron frequently.') . '</p>',
    ];

    $form['cron_frequency'] = [
      '#type' => 'select',
      '#title' => $this->t('Cron frequency'),
      '#description' => $this->t('How often should the cron optimize the tables?'),
      '#options' => [
        3600 => $this->t('Hourly'),
        86400 => $this->t('Daily'),
        604800 => $this->t('Weekly'),
      ],
      '#default_value' => $config->get('cron_frequency') ?? 86400,
    ];

    // Get the list of database tables.
    $tables = Database::getConnection()->query('SHOW TABLES')->fetchCol();

    $options = array_combine($tables, $tables);

    $form['cron_tables'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Tables to optimize during cron'),
      '#description' => $this->t('Select the tables that should be optimized. If none are selected, all database tables will be optimized.'),
      '#options' => $options,
      '#default_value' => $config->get('cron_tables') ?? [],
    ];

    $form['message'] = [
      '#markup' => '<p><strong>Note:</strong> If you specify one or more table names above, the cron will optimize only those tables. If you leave this field empty, all database tables will be optimized during cron execution.</p>',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Remove unchecked values (they come as 0).
    $selected_tables = array_filter($form_state->getValue('cron_tables'));

    $this->config('dboptimize.settings')
      ->set('cron_tables', $selected_tables)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
