<?php

namespace Drupal\dboptimize\Commands;

use Drush\Commands\DrushCommands;

/**
 * Provides a Drush command to run dboptimize_cron.
 */
class DbOptimizeCommands extends DrushCommands {

  /**
   * Runs the dboptimize hook.
   *
   * @command dboptimize:optimize
   * @aliases dbo
   */
  public function runDbOptimize(array $options = ['tables' => '']) {
    $tables = $options['tables'] ?? '';

    $this->output()->writeln('▶️ Running dboptimize...');

    \Drupal::service('dboptimize.cron')->__invoke($tables);

    $this->output()->writeln('✅ dboptimize completed.');
  }

}
