<?php

namespace Drupal\dboptimize\Commands;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Drush command to run dboptimize_cron.
 */
class DbOptimizeCommands extends DrushCommands {

  /**
   * The module handler service.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * Constructs a new DbHealthCronCommands object.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler service.
   */
  public function __construct(ModuleHandlerInterface $module_handler) {
    parent::__construct();
    $this->moduleHandler = $module_handler;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('module_handler')
    );
  }

  /**
   * Runs the dboptimize hook.
   *
   * @command dboptimize:optimize
   * @aliases dbo
   */
  public function runDbOptimize(array $options = ['tables' => '']) {
    $tables = $options['tables'] ?? '';

    $this->output()->writeln('▶️ Running dboptimize...');

    $this->moduleHandler->invoke('dboptimize', 'cron', [$tables]);

    $this->output()->writeln('✅ dboptimize completed.');
  }

}
