<?php

namespace Drupal\dc_ajax_add_cart\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\commerce_product\Plugin\Field\FieldFormatter\AddToCartFormatter;

/**
 * Plugin implementation of the 'dc_ajax_add_cart' formatter.
 *
 * @FieldFormatter(
 *   id = "dc_ajax_add_cart",
 *   label = @Translation("Ajax add to cart form"),
 *   field_types = {
 *     "entity_reference"
 *   }
 * )
 */
class AjaxAddToCartFormatter extends AddToCartFormatter {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $elements = parent::viewElements($items, $langcode);

    $product = $items->getEntity();
    if (empty($elements) || !empty($product->in_preview)) {
      return $elements;
    }

    // Replace add_to_cart_form by the dc_ajax_add_cart_form.
    $elements[0]['dc_ajax_add_cart_form'] = $elements[0]['add_to_cart_form'];
    $elements[0]['dc_ajax_add_cart_form']['#lazy_builder'][0] = 'dc_ajax_add_cart.lazy_builders:ajaxAddToCartForm';
    unset($elements[0]['add_to_cart_form']);

    return $elements;
  }

}
