# Decoupled Entity Notifications (DEN)

## Introduction

The Decoupled Entity Notifications module provides a robust API for subscribing to entity updates, enabling seamless integration with decoupled frontends.

### Key Features
- **Subscription Management**: Allows users to subscribe to changes in specific entities.
- **Customizable Notifications**: Introduces a `notifications_settings` field that can be added to entity bundles. This field includes:
  - A subfield to control whether an entity can be subscribed to.
  - A user-configurable subfield for sending notifications on specific changes, along with a text field for detailed descriptions.

### Automated Processes
This module includes two automated cron jobs:
1. **Queue: Notify Subscribers** - Handles the delivery of notifications to subscribers.
2. **Clean Up Unconfirmed Subscriptions** - Periodically removes unconfirmed subscriptions based on the "Time to live for confirm URL token" setting.

## Installation Instructions

Follow these steps to set up the Notifications module:

1. **Enable the Module**: Install and enable the module in your Drupal site.
2. **Set the Secret Key**: Add the following line to your `settings.php` file, replacing `<SECRET_KEY>` with a secure, private value. Using an environment variable for this key is highly recommended.
   ```php
   $config['de_notifications.settings']['secret_key'] = <SECRET_KEY>;
   ```
3. **Configure Module Settings**: Go to `admin/config/system/de_notifications` to adjust the module’s settings.
4. **Set Up Cron Jobs**: Configure the desired schedules for the "Clean up unconfirmed subscriptions" and "Queue: Notify Subscribers" cron jobs in your site's cron settings.
5. **Add the Notifications Field**: Add the `notifications_settings` field to the desired entity bundle(s).
6. **Enable the Field**: Activate the added field for one or more instances of your entity.
7. **Use the Endpoints**: Make API requests to the module’s available endpoints as outlined in the documentation.

## Endpoints
## Subscribe

### Endpoint
**POST** `/api/v1/de_notifications/subscribe`

### Headers
- `Content-Type`: `application/x-www-form-urlencoded`
- `Accept`: `application/vnd.api+json`
- `X-CSRF-Token`: `{x-csrf-token}`
- `X-Client-Ip`: `{ip address of the user}`

### Body Parameters
| Field        | Type               | Description                       |
|--------------|--------------------|-----------------------------------|
| `email`      | `string`           | User's email address              |
| `eid`        | `string \| number` | Entity ID for subscription        |
| `entity_type`| `string`           | Type of entity being subscribed to |

### Example Request
```http
POST /api/v1/de_notifications/subscribe
Content-Type: application/x-www-form-urlencoded
Accept: application/vnd.api+json
X-CSRF-Token: {x-csrf-token}
X-Client-Ip: {user ip}

email=example@example.com
eid=12345
entity_type=node
```
## Confirm Subscription

### Endpoint
**POST** `/api/v1/de_notifications/confirm`

### Headers
- `Content-Type`: `application/x-www-form-urlencoded`
- `Accept`: `application/vnd.api+json`
- `X-CSRF-Token`: `{x-csrf-token}`

### Body Parameters
| Field   | Type     | Description                 |
|---------|----------|-----------------------------|
| `token` | `string` | Subscription confirmation token |

### Example Request
```http
POST /api/v1/de_notifications/confirm
Content-Type: application/x-www-form-urlencoded
Accept: application/vnd.api+json
X-CSRF-Token: {x-csrf-token}

token=abcdef123456
```

## Unsubscribe

### Endpoint
**POST** `/api/v1/de_notifications/unsubscribe`

### Headers
- `Content-Type`: `application/x-www-form-urlencoded`
- `Accept`: `application/vnd.api+json`
- `X-CSRF-Token`: `{x-csrf-token}`

### Body Parameters
| Field   | Type     | Description                 |
|---------|----------|-----------------------------|
| `token` | `string` | Unsubscribe token            |

### Example Request
```http
POST /api/v1/de_notifications/unsubscribe
Content-Type: application/x-www-form-urlencoded
Accept: application/vnd.api+json
X-CSRF-Token: {x-csrf-token}

token=abcdef123456
```

## Unsubscribe All

### Endpoint
**POST** `/api/v1/de_notifications/unsubscribe/all`

### Headers
- `Content-Type`: `application/x-www-form-urlencoded`
- `Accept`: `application/vnd.api+json`
- `X-CSRF-Token`: `{x-csrf-token}`

### Body Parameters
| Field   | Type     | Description                                   |
|---------|----------|-----------------------------------------------|
| `token` | `string` | Token to unsubscribe from all notifications   |

### Example Request
```http
POST /api/v1/de_notifications/unsubscribe/all
Content-Type: application/x-www-form-urlencoded
Accept: application/vnd.api+json
X-CSRF-Token: {x-csrf-token}

token=abcdef123456
```

## Request subscription overview

### Endpoint
**POST** `/api/v1/de_notifications/request_subscription_overview`

### Headers
- `Content-Type`: `application/x-www-form-urlencoded`
- `Accept`: `application/vnd.api+json`
- `X-CSRF-Token`: `{x-csrf-token}`

### Body Parameters
| Field   | Type     | Description                            |
|---------|----------|----------------------------------------|
| `token` | `string` | Token to request subscription overview |

### Example Request
```http
POST /api/v1/de_notifications/unsubscribe/all
Content-Type: application/x-www-form-urlencoded
Accept: application/vnd.api+json
X-CSRF-Token: {x-csrf-token}

token=abcdef123456
```
