<?php

declare(strict_types=1);

namespace Drupal\de_notifications_symfony_mailer\Plugin\EmailBuilder;

use Drupal\symfony_mailer\Processor\EmailBuilderBase;

/**
 * Email Builder plug-in for Notifications module.
 *
 * @EmailBuilder(
 *   id = "de_notifications_mailer",
 *   sub_types = {
 *     "confirm" = @Translation("Confirm entity subscription"),
 *     "subscription_confirmed" = @Translation("Subscription confirmed"),
 *     "already_subscribed" = @Translation("Already subscribed"),
 *     "entity_notification" = @Translation("Entity notification"),
 *     "subscription_overview" = @Translation("Subscription overview"),
 *     "archived" = @Translation("Entity archived"),
 *   },
 *   label = "Notifications Email builder",
 *   common_adjusters = {"email_subject", "email_body"},
 * )
 */
class SymfonyEmailBuilder extends EmailBuilderBase {

}
