<?php

declare(strict_types=1);

namespace Drupal\de_notifications\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form controller for the notifications subscription entity edit forms.
 */
class NotificationsSubscriptionForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state): int {
    $result = parent::save($form, $form_state);

    $message_args = ['%label' => $this->entity->toLink()->toString()];
    $logger_args = [
      '%label' => $this->entity->label(),
      'link' => $this->entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New notifications subscription %label has been created.', $message_args));
        $this->logger('notifications')->notice('New notifications subscription %label has been created.', $logger_args);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The notifications subscription %label has been updated.', $message_args));
        $this->logger('notifications')->notice('The notifications subscription %label has been updated.', $logger_args);
        break;

      default:
        throw new \LogicException('Could not save the entity.');
    }

    $form_state->setRedirectUrl(Url::fromRoute('view.notification_subscriptions.overview'));

    return $result;
  }

}
