<?php

declare(strict_types=1);

namespace Drupal\de_notifications;

/**
 * The Notifications Context Service Interface.
 */
interface NotificationsContextServiceInterface {

  /**
   * Set the subscription.
   *
   * @param \Drupal\de_notifications\NotificationsSubscriptionInterface $subscription
   *   The subscription.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   */
  public function setSubscription(NotificationsSubscriptionInterface $subscription): void;

  /**
   * Set the subscriber.
   *
   * @param \Drupal\de_notifications\NotificationsSubscriberInterface $subscriber
   *   The subscriber.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   */
  public function setSubscriber(NotificationsSubscriberInterface $subscriber): void;

  /**
   * Change config language.
   *
   * @param string $langcode
   *   The iso langcode.
   */
  public function setLanguage(string $langcode): void;

  /**
   * Returns the latest version of the title of the subscribed to entity.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getLatestEntityTitle(): string;

  /**
   * Returns the latest version of the url of the subscribed to entity.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getLatestEntityUrl(): string;

  /**
   * Returns the subscriber's email address.
   *
   * @throws \Exception
   */
  public function getSubscriberEmail(): string;

  /**
   * Returns confirm url with token parameter included.
   *
   * @return string
   *   The confirm url.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getConfirmUrl(): string;

  /**
   * Returns unsubscribe url with token parameter included.
   *
   * @return string
   *   The unsubscribe url.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getUnsubscribeUrl(): string;

  /**
   * Returns unsubscribe all url with token parameter included.
   *
   * @return string
   *   The unsubscribe all url.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getUnsubscribeAllUrl(): string;

  /**
   * Returns url to request subscription overview with token parameter included.
   *
   * @return string
   *   The url to request subscription overview.
   *
   * @throws \Drupal\Core\TypedData\Exception\MissingDataException
   * @throws \Exception
   */
  public function getRequestSubscriptionOverviewUrl(): string;

  /**
   * Returns all subscriptions for the current subscriber.
   *
   * @throws \Exception
   */
  public function getSubscriptions(): array;

}
