<?php

namespace Drupal\de_notifications;

/**
 * Provides an interface for the NotificationsTokenService.
 */
interface NotificationsTokenServiceInterface {

  /**
   * Generate token for confirm/unsubscribe/unsubscribeAll url.
   *
   * @param string $uuid
   *   Uuid of the subscriber or subscription.
   * @param int $ttl
   *   Time to live for the token.
   *
   * @return string
   *   Returns the token generated by the service.
   *
   * @throws \Drupal\de_notifications\Exception\NotificationsException
   */
  public function generateToken(string $uuid, int $ttl): string;

  /**
   * Validate token for confirm/unsubscribe/unsubscribeAll url.
   *
   * @param string $token
   *   Token to validate.
   *
   * @return string
   *   Returns the subscriber or subscription uuid
   *
   * @throws \Drupal\de_notifications\Exception\NotificationsException
   */
  public function validateToken(string $token): string;

}
