<?php

declare(strict_types=1);

namespace Drupal\de_notifications\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Language\LanguageInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of 'notification_settings_default' formatter.
 */
#[FieldFormatter(
  id: 'notification_settings_default',
  label: new TranslatableMarkup('Default'),
  field_types: [
    'notification_settings',
  ],
)]
class NotificationSettingsDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode): array {
    $element = [];

    foreach ($items as $delta => $item) {
      $element[$delta] = [
        '#theme' => 'de_notifications_settings',
        '#subscription_enabled' => $item->subscription_enabled,
        '#send_notification' => $item->send_notification,
        '#changes' => $item->changes,
        '#cache' => [
          'contexts' => [
            'languages:' . LanguageInterface::TYPE_INTERFACE,
          ],
        ],
      ];
    }

    return $element;
  }

}
