<?php

namespace Drupal\de_notifications\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates a path.
 *
 * @Constraint(
 *   id = "NotificationsPath",
 *   label = @Translation("Notifications Path", context = "Validation"),
 *   type = "string"
 * )
 */
class NotificationsPathConstraint extends Constraint {

  /**
   * Error message when path doesn't start with a forward slash.
   *
   * @var string
   */
  public string $noLeadingSlash = 'The path must start with a forward slash (/).';

  /**
   * Error message when path ends with a forward slash.
   *
   * Examples:
   * Valid: /path
   * Invalid: /path/
   *
   * @var string
   */
  public string $noTrailingSlash = 'The path must not end with a forward slash (/).';

  /**
   * Error message when path contains invalid characters.
   *
   * Valid characters are:
   * - Alphanumeric (a-z, A-Z, 0-9)
   * - Hyphens (-)
   * - Underscores (_)
   * - Forward slashes (/)
   *
   * @var string
   */
  public string $invalidPathChars = 'The path contains invalid characters. Only alphanumeric characters, hyphens, underscores, and forward slashes are allowed.';

  /**
   * Error message when query parameters contain invalid characters.
   *
   * Valid characters are:
   * - Alphanumeric (a-z, A-Z, 0-9)
   * - Hyphens (-)
   * - Underscores (_)
   * - Equals signs (=)
   * - Ampersands (&)
   *
   * @var string
   */
  public string $invalidQueryChars = 'Query parameters contain invalid characters. Only alphanumeric characters, hyphens, underscores, equals signs, and ampersands are allowed.';

  /**
   * Error message when query parameter format is invalid.
   *
   * Query parameters must be in the format:
   * ?key1=value1&key2=value2
   *
   * @var string
   */
  public string $invalidQueryFormat = 'Invalid query parameter format. Each parameter must be in the format key=value.';

  /**
   * Error message when query parameter is missing key or value.
   *
   * Both key and value must be non-empty strings:
   * Valid: ?key=value
   * Invalid: ?key= or ?=value or ?=
   *
   * @var string
   */
  public string $emptyKeyValue = 'Query parameters must have both a key and a value.';

}
