<?php

namespace Drupal\de_notifications\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates a URL.
 *
 * @Constraint(
 *   id = "NotificationsUrl",
 *   label = @Translation("Notifications URL", context = "Validation"),
 *   type = "string"
 * )
 */
class NotificationsUrlConstraint extends Constraint {

  /**
   * Error message when URL ends with a forward slash.
   *
   * The URL must not end with a forward slash.
   *
   * Examples:
   * Valid: https://example.com
   * Invalid: https://example.com/
   *
   * @var string
   */
  public string $noTrailingSlash = 'The URL must not end with a forward slash (/).';

  /**
   * Error message when URL format is invalid.
   *
   * The URL must:
   * - Have a valid scheme (http:// or https://)
   * - Have a valid hostname
   * - Optional path, query parameters and fragments.
   *
   * Examples:
   * Valid: https://example.com, http://localhost:8080
   * Invalid: example.com, ftp://example.com
   *
   * @var string
   *
   * @see \filter_var()
   * @see FILTER_VALIDATE_URL
   */
  public string $invalidUrl = 'The URL %value must be a valid URL.';

}
