<?php

namespace Drupal\de_notifications\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates the NotificationsURL constraint.
 */
class NotificationsUrlConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate($value, Constraint $constraint) {
    if (empty($value)) {
      return;
    }

    if (str_ends_with($value, '/')) {
      $this->context->addViolation($constraint->noTrailingSlash);
      return;
    }

    if (!filter_var($value, FILTER_VALIDATE_URL)) {
      $this->context->addViolation($constraint->invalidUrl, ['%value' => $value]);
      return;
    }

    return $value;
  }

}
