<?php

namespace Drupal\de_notifications\Plugin\views\field;

use Drupal\Core\Form\FormStateInterface;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to expose subscription status as a field in views.
 *
 * Displays default value for entities without notifications.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("notifications_status")
 */
class NotificationStatus extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  protected function defineOptions(): array {
    $options = parent::defineOptions();
    $options['label_notifications_enabled'] = ['default' => 'Yes'];
    $options['label_notifications_disabled'] = ['default' => 'No'];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    $form['label_notifications_enabled'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label notifications enabled'),
      '#description' => $this->t('Specify the label used to indicate that notifications are enabled.'),
      '#default_value' => $this->options['label_notifications_enabled'],
    ];
    $form['label_notifications_disabled'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label notifications disabled'),
      '#description' => $this->t('Specify the label used to indicate that notifications are disabled.'),
      '#default_value' => $this->options['label_notifications_disabled'],
    ];
    parent::buildOptionsForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    /** @var \Drupal\Core\Entity\ContentEntityInterface $entity */
    $entity = $values->_entity;

    if ($entity->hasField('field_notifications')
      && isset($entity->get('field_notifications')[0])
      && (string) $entity->get('field_notifications')->getValue()[0]['subscription_enabled'] === '1') {
      return $this->options['label_notifications_enabled'];
    }
    return $this->options['label_notifications_disabled'];
  }

  /**
   * {@inheritdoc}
   */
  public function query() {}

}
