<?php

declare(strict_types=1);

namespace Drupal\de_notifications_test\Plugin\NotificationType;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\State\StateInterface;
use Drupal\de_notifications\NotificationsSubscriberInterface;
use Drupal\de_notifications\NotificationsSubscriptionInterface;
use Drupal\de_notifications\Plugin\NotificationTypeBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The notifications test type.
 *
 * @NotificationType(
 *   id = "test_type",
 *   label = @Translation("Test type"),
 * )
 */
class TestType extends NotificationTypeBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs the TestType plugin.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\State\StateInterface $state
   *   The state storage object.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected readonly StateInterface $state,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('state')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function sendConfirmation(NotificationsSubscriptionInterface $subscription): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * {@inheritdoc}
   */
  public function sendSubscriptionConfirmed(NotificationsSubscriptionInterface $subscription): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * {@inheritdoc}
   */
  public function sendAlreadySubscribed(NotificationsSubscriptionInterface $subscription): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * {@inheritdoc}
   */
  public function sendSubscriptionOverview(NotificationsSubscriberInterface $subscriber, string $langcode): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * {@inheritdoc}
   */
  public function sendEntityNotification(NotificationsSubscriptionInterface $subscription, string $entity_title, string $changes): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * {@inheritdoc}
   */
  public function sendArchived(NotificationsSubscriptionInterface $subscription): void {
    $this->setMethod(__FUNCTION__);
  }

  /**
   * Set the method being called.
   *
   * @param string $method
   *   The method being called.
   */
  private function setMethod(string $method): void {
    $key = "de_notifications_test.test_type.method.{$method}";
    $this->state->set($key, TRUE);
  }

}
