# Debug Cacheability Headers Split

Debug Cacheability Headers Split solves the errors that occur in some environment
set-ups where a size limit per HTTP header is enforced by the server and
Drupal core's debug cacheability headers (when enabled) may exceed this limit.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/debug_cacheability_headers_split).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/debug_cacheability_headers_split).

## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers

## Requirements

No additional modules are required for installing and using this module.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

The default applicable configuration for the header limits is:
- 8192 (8KB) for the size limit per header
- 8000 (< 8KB) for the header chunk size when split

You may configure these at /admin/config/development/settings/cacheability.

Alternatively, you may override them via `settings.local.php` file as follows: 
````
$config['debug_cacheability_headers_split.settings']['header_size_limit'] = 5120;
$config['debug_cacheability_headers_split.settings']['header_chunk_size'] = 5000;
````

## Maintainers

Current maintainers:

- [Argyro Kazaki (akz)](https://www.drupal.org/u/akz)

Credits to all users that have contributed to these issues:
- https://www.drupal.org/project/drupal/issues/2954339
- https://www.drupal.org/project/drupal/issues/2844620

Supporting organizations:

- [EWORX S.A.](https://www.drupal.org/eworx-sa)
