/**
 * @file
 * JS behaviors for the decorative image widget.
 */
((Drupal, once) => {
  function enableOrDisableAltTextField(altTextField, enable) {
    if (!enable) {
      // Edit input field attributes
      altTextField.disabled = true;
      altTextField.removeAttribute('required');
      altTextField.classList.remove('required');
      // Edit parent element classes
      const parent = altTextField.parentElement;
      if (parent) {
        parent.classList.add('form-disabled');
        // Edit label element
        const label = parent.querySelector('label');
        if (label) {
          label.classList.remove('form-required');
        }
      }
    } else {
      // Edit input field attributes
      altTextField.disabled = false;
      altTextField.setAttribute('required', 'required');
      altTextField.classList.add('required');
      // Edit parent element classes
      const parent = altTextField.parentElement;
      if (parent) {
        parent.classList.remove('form-disabled');
        // Edit label element
        const label = parent.querySelector('label');
        if (label) {
          label.classList.add('form-required');
        }
      }
    }
  }

  Drupal.behaviors.decorativeImageWidget = {
    attach(context) {
      // When the decorative image checkbox is checked, disable the alt
      // text field.
      once(
        'decorative-image-widget',
        '.image-widget .decorative-checkbox',
        context,
      ).forEach(function processCheckbox(checkbox) {
        const widget = checkbox.closest('.image-widget');
        const altTextField = widget.querySelector('.alt-textfield');
        checkbox.addEventListener('change', (event) => {
          enableOrDisableAltTextField(altTextField, !event.target.checked);
        });
        enableOrDisableAltTextField(altTextField, !checkbox.checked);
      });
    },
  };
})(Drupal, once);
