<?php

declare(strict_types=1);

namespace Drupal\decoupled_kit;

use Symfony\Component\HttpFoundation\Request;

/**
 * The Decoupled Kit interface.
 */
interface DecoupledKitInterface {

  /**
   * Canonical path.
   *
   * @param string $path
   *   Input path.
   * @param bool $url_path_only
   *   Only path part of url.
   *
   * @return string
   *   Canonical path.
   */
  public function canonicalPath($path, $url_path_only = TRUE): string;

  /**
   * Check request path.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   User request.
   * @param bool $needCanonicalUrl
   *   Need call canonicalPath().
   *
   * @return string
   *   Checked path or exception if empty.
   */
  public function checkPath(Request $request, $needCanonicalUrl = TRUE): string;

  /**
   * Get entity from path.
   *
   * @param string $path
   *   Path.
   *
   * @return object|bool
   *   Entity object or null.
   */
  public function getEntityFromPath($path);

  /**
   * Get Routematch from path.
   *
   * @param string $path
   *   Path.
   *
   * @return \Drupal\Core\Routing\RouteMatch|bool
   *   Entity object or null.
   */
  public function getRouteMatchFromPath($path);

}
