<?php

declare(strict_types=1);

namespace Drupal\deferred_callbacks;

/**
 * Defines an interface for a deferred callback collection.
 */
interface DeferredCallbackCollectionInterface {

  /**
   * Adds a deferred callback to the collection.
   *
   * @param callable $callback
   *   The callback to add.
   * @param int $priority
   *   (optional) Priority for the callback. Higher values run first.
   *   Defaults to 0.
   * @param string|null $name
   *   (optional) Human-readable name for debugging and logging.
   */
  public function push(callable $callback, int $priority = 0, ?string $name = NULL): void;

  /**
   * Executes all deferred callbacks in the collection.
   */
  public function execute(): void;

}
