<?php

declare(strict_types=1);

namespace Drupal\deferred_callbacks\EventSubscriber;

use Drupal\deferred_callbacks\DeferredCallbackCollectionInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\TerminateEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Subscribes to kernel.terminate to execute deferred callbacks.
 */
final class TerminateSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new TerminateSubscriber object.
   *
   * @param \Drupal\deferred_callbacks\DeferredCallbackCollectionInterface $collection
   *   The deferred callback collection.
   */
  public function __construct(
    private readonly DeferredCallbackCollectionInterface $collection,
  ) {}

  /**
   * Executes deferred callbacks on kernel.terminate.
   *
   * @param \Symfony\Component\HttpKernel\Event\TerminateEvent $event
   *   The terminate event.
   */
  public function onTerminate(TerminateEvent $event): void {
    $this->collection->execute();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::TERMINATE => ['onTerminate', 0],
    ];
  }

}
